<?php $__env->startSection('content'); ?>
<?php if(!$projects->is_active): ?>
<div class="overlay" id="overlay">
    <div class="container h-100">
        <div class="row align-items-center justify-content-center h-100">
            <div class="col-md-4 text-center text-md-start">
                <p class="coming-soon">
                    <?php echo e(\App\Helpers\TranslationHelper::translate('This content will be available soon')); ?>

                </p>
            </div>
            <div class="col-md-4 text-center">
                <button class="lock-btn" onclick="unlockContent()">
                    <img src="<?php echo e(asset('front/assets/img/lock.png')); ?>" alt="" class="img-fluid">
                </button>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>



<section class="hero-section py-5" style="background: linear-gradient(to right, #a42249, #6d1330);">
    <div class="container">
        <div class="row justify-content-center align-items-center text-center g-4">

            <!-- صورة المشروع -->
            
            <div class="col-md-3 d-flex flex-column align-items-center align-self-start">
                <img src="<?php echo e($projects->getFirstMediaUrl('projects_image')); ?>" class="img-fluid rounded"
                    alt="<?php echo e($projects->name); ?>" style="max-width: 140px; height: auto;">
                


            <div class="d-flex justify-content-center mt-3">
                <button class="download-btn mx-2">
                    <img src="<?php echo e(asset('front/assets/img/android.jpg')); ?>" alt="Download for Android">
                </button>
                <button class="download-btn mx-2">
                    <img src="<?php echo e(asset('front/assets/img/ios.jpg')); ?>" alt="Download for iPhone">
                </button>
            </div>




        </div>

        <div class="col-md-6 text-center">
            <h2 class="fw-bold text-white" data-aos="zoom-in"><?php echo e($projects->name); ?></h2>
            <div class="description-box p-4 rounded shadow-lg"
                style="background: rgba(255, 255, 255, 0.2); line-height: 1.8em; max-width: 100%; margin: auto;">
                <p class="text-white"><?php echo $projects->description; ?></p>
            </div>
        </div>

        <div class="col-md-3 d-flex justify-content-center align-self-start mt-n3">
            <img src="<?php echo e(asset(setting('image_logo', 'en'))); ?>" class="img-fluid rounded" alt="Logo"
                style="max-width: 150px; height: auto;">
        </div>

    </div>
    </div>
</section>






<section class="video-section py-5" style="background: linear-gradient(to right, #a42249, #6d1330);">
    <div class="container" style="max-width: 960px; margin: auto;">
        <div class="row justify-content-center">

            <div class="col-md-6 d-flex justify-content-center">
                <div class="card shadow-lg border-0" style="width: 90%;">
                    <div class="ratio ratio-16x9">
                        <video controls style="width: 100%; height: 250px; object-fit: cover;">
                            <source src="<?php echo e($projects->getFirstMediaUrl('projectsproject_video_one')); ?>"
                                type="video/mp4">
                        </video>
                    </div>
                </div>
            </div>

            <div class="col-md-6 d-flex justify-content-center">
                <div class="card shadow-lg border-0" style="width: 90%;">
                    <div class="ratio ratio-16x9">
                        <video controls style="width: 100%; height: 250px; object-fit: cover;">
                            <source src="<?php echo e($projects->getFirstMediaUrl('projectsproject_video_tow')); ?>"
                                type="video/mp4">
                        </video>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\youseif\Couronne-Royale\resources\views/front/pages/projects.blade.php ENDPATH**/ ?>