<?php $__env->startSection('content'); ?>

<!-- Hero Section -->
<section class="hero-section">
    <div class="overlay"></div>
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-md-10 text-center">
                <div class="text-hero-7">
                    <h2 data-aos="zoom-in" data-aos-duration="1000">
                        <?php echo e(setting('title', app()->getLocale())); ?>

                    </h2>
                    <p data-aos="fade-up" data-aos-duration="1200">
                        <?php echo e(setting('title_tow', app()->getLocale())); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contact Us Section -->
<section class="contact-us">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="text-contact" style="color:#fff !important;">
                    <h2 style="color: rgb(241, 196, 15);">
                           <?php echo e(\App\Helpers\TranslationHelper::translate('Royal Crown Vip News')); ?>

                    </h2>
                     <?php echo setting('description', app()->getLocale()); ?>

                   
                </div>
            </div>
            <div class="col-md-6" style="margin-top: 20px;">
    <div class="img-contact">
        <img src="<?php echo e(setting('image_one_news', 'en')); ?>" alt=""
             style="height: 300px; object-fit: cover; border-radius: 12px; box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);">
    </div>
</div>
        </div>
    </div>
</section>

<!-- Videos Section -->
<section class="news-section" style="padding: 40px 0;">
    
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $new): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-6 mb-4 d-flex justify-content-center">
                    <div style="background-color: #a42249; box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1); padding: 20px; border-radius: 12px; width: 100%; max-width: 540px;">
                        <video width="100%" height="250" controls style="border-radius: 12px;">
                            <source src="<?php echo e($new->getFirstMediaUrl('newsnews_video')); ?>" type="video/mp4">
                        </video>
                        <div class="rc-post-content" style="text-align: center; margin-top: 10px;">
                            <div class="rc-meta d-flex justify-content-center align-items-center mb-2" style="gap: 5px;">
                                <i class="fa-solid fa-calendar-days" style="color: #fff;"></i>
                                <span style="color: #fff;"><?php echo e($new->created_at->format('Y-m-d')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<section class="latest-blogs" style="padding: 40px 0;">
    <div class="container">
        <h2 class="text-center mb-4" style="color: rgb(241, 196, 15);">
            <?php echo e(\App\Helpers\TranslationHelper::translate('Latest Articles')); ?>

        </h2>
        <div class="row">
            
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4 mb-4 d-flex">
                    <div class="card" style="border-radius: 12px; box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1); display: flex; flex-direction: column; height: 100%;">
                        <img src="<?php echo e($blog->getFirstMediaUrl('blogs_image')); ?>" alt="<?php echo e($blog->name); ?>" class="card-img-top" style="height: 200px; object-fit: cover; border-radius: 12px 12px 0 0;">
                        <div class="card-body" style="flex-grow: 1; display: flex; flex-direction: column;">
                            <h5 class="card-title" style="color: #a42249;"><?php echo e($blog->name); ?></h5>
                            <p class="card-text" style="flex-grow: 1;"><?php echo e(Str::words(strip_tags($blog->description), 30, '...')); ?></p>
                            <a href="<?php echo e(route('news-video')); ?>" class="btn btn-primary" style="background-color: #a42249; border: none; align-self: flex-end;">
                                <?php echo e(\App\Helpers\TranslationHelper::translate('More Articles')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- Latest Blogs Section -->


<?php $__env->stopSection(); ?>










<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\youseif\Couronne-Royale\resources\views/front/pages/blog/index.blade.php ENDPATH**/ ?>