@extends('front.layouts.app')

@section('content')
    {{-- <div class="overlay" id="overlay">
        <div class="container h-100">
            <div class="row align-items-center justify-content-center h-100">
                <div class="col-md-4 text-center text-md-start">
                    <p class="coming-soon">
                        {{ \App\Helpers\TranslationHelper::translate('This content will be available soon') }}</p>
                </div>
                <div class="col-md-4 text-center">
                    <button class="lock-btn" onclick="unlockContent()">
                        <img src="{{ asset('front/assets/img/lock.png') }}" alt="" class="img-fluid">
                    </button>
                </div>
            </div>
        </div>
    </div>  --}}

    {{-- @php
    $locale = app()->getLocale();
@endphp

<section class="charitable-works-section py-5 text-center" style="background: linear-gradient(to right, #a42249, #6d1330);">
    <div class="container">
        <h2 class="fw-bold text-white mb-5" data-aos="fade-down">{{ setting('title_charitableWork', $locale) }}</h2>

        <div class="row g-4">
            @foreach($charitableWorks as $charitableWork)
                @php
                    $videoUrl = $charitableWork->getFirstMediaUrl('charitableWork_video_one_' . $locale);
                @endphp

                @if ($videoUrl)
                    <div class="col-md-6">
                        <div class="card shadow-lg border-0 overflow-hidden p-3" style="background: rgba(255, 255, 255, 0.1); border-radius: 15px;">
                            <video controls class="rounded shadow w-100" style="height: 300px; object-fit: cover;">
                                <source src="{{ $videoUrl }}" type="video/mp4">
                                {{ __('Your browser does not support the video tag.') }}
                            </video>
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    </div>
</section> --}}

 @php
 $locale = app()->getLocale();
@endphp

<section class="charitable-works-section py-5 text-center" style="color:#fff !important; background: linear-gradient(to right, #a42249, #6d1330);">
 <div class="container">
     <h2 class="fw-bold text-white mb-5" data-aos="fade-down">{{ setting('title_charitableWork', $locale) }}</h2>

     <div class="row g-5">
         @foreach($charitableWorks as $charitableWork)
             @php
                 $videoUrl = $charitableWork->getFirstMediaUrl('charitableWork_video_one_' . $locale);
                 $imageUrl = $charitableWork->getFirstMediaUrl('_image');
                 $description = $charitableWork->getTranslation('description', $locale);
             @endphp

             <div class="col-12">
                 <div class="card shadow-lg border-0 overflow-hidden p-4"
                      style="color:#fff !important; background: rgba(255, 255, 255, 0.08); border-radius: 20px; backdrop-filter: blur(10px);">
                     
                      {{-- <div class="row g-3 align-items-stretch">
                        <div class="col-md-6">
                            @if($imageUrl)
                                <img src="{{ $imageUrl }}" alt="Charitable Work Image"
                                     class="img-fluid rounded w-100 h-100" style="object-fit: cover; min-height: 300px;">
                            @else
                                <div style="background-color: #222; height: 300px;" class="rounded w-100"></div>
                            @endif
                        </div>
                    
                        <div class="col-md-6">
                            @if($videoUrl)
                                <video controls class="w-100 rounded shadow h-100" style="object-fit: cover; min-height: 300px;">
                                    <source src="{{ $videoUrl }}" type="video/mp4">
                                    {{ __('Your browser does not support the video tag.') }}
                                </video>
                            @else
                                <div style="background-color: #222; height: 300px;" class="rounded w-100"></div>
                            @endif
                        </div>
                    </div>
                     --}}
                     <div class="row g-3 align-items-center">
                         @if($imageUrl)
                             <div class="col-md-6">
                                 <img src="{{ $imageUrl }}" alt="Charitable Work Image"
                                      class="img-fluid rounded w-100" style="height: 300px; object-fit: cover;">
                             </div>
                         @endif

                         @if($videoUrl)
                             <div class="col-md-6">
                                 <video controls class="w-100 rounded shadow" style="height: 300px; object-fit: cover;">
                                     <source src="{{ $videoUrl }}" type="video/mp4">
                                     {{ __('Your browser does not support the video tag.') }}
                                 </video>
                             </div>
                         @endif
                     </div>

                     @if($description)
                         <div class="mt-4 text-start">
                             <p class="text-white m-0" style="font-size: 17px;">
                                 {!! $description !!}
                             </p>
                         </div>
                     @endif
                 </div>
             </div>
         @endforeach
     </div>
 </div>
</section>

 
    {{-- <section class="charitable-works-section py-5 text-center" style="background: linear-gradient(to right, #a42249, #6d1330);">
        <div class="container">
            <h2 class="fw-bold text-white mb-5" data-aos="fade-down">{{(setting('title_charitableWork', 'en')) }}</h2>
    
            <div class="row g-4">
                @foreach($charitableWorks as $charitableWork)
                <div class="col-md-6">
                    <div class="card shadow-lg border-0 overflow-hidden p-3" style="background: rgba(255, 255, 255, 0.1); border-radius: 15px;">
                        <video controls class="rounded shadow w-100" style="height: 300px; object-fit: cover;">
                            <source src="{{ $charitableWork->getFirstMediaUrl('charitable__workscharitableWork_video_one') }}" type="video/mp4">
                        </video>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section> --}}
    


@endsection




@push('js')
    {{-- <script>
        function unlockContent() {
            let overlay = document.getElementById("overlay");
            overlay.style.opacity = "0";
            setTimeout(() => {
                overlay.style.display = "none";
                document.getElementById("main-content").style.display = "block";
            }, 300);
        }
    </script> --}}
@endpush
