<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'The :attribute must be accepted.',
    'accepted_if' => 'The :attribute must be accepted when :other is :value.',
    'active_url' => 'The :attribute is not a valid URL.',
    'after' => 'The :attribute must be a date after :date.',
    'after_or_equal' => 'The :attribute must be a date after or equal to :date.',
    'alpha' => 'The :attribute must only contain letters.',
    'alpha_dash' => 'The :attribute must only contain letters, numbers, dashes and underscores.',
    'alpha_num' => 'The :attribute must only contain letters and numbers.',
    'array' => 'The :attribute must be an array.',
    'before' => 'The :attribute must be a date before :date.',
    'before_or_equal' => 'The :attribute must be over 21 years old',
    'between' => [
        'numeric' => 'The :attribute must be between :min and :max.',
        'file' => 'The :attribute must be between :min and :max kilobytes.',
        'string' => 'The :attribute must be between :min and :max characters.',
        'array' => 'The :attribute must have between :min and :max items.',
    ],
    'boolean' => 'The :attribute field must be true or false.',
    'confirmed' => 'The :attribute confirmation does not match.',
    'current_password' => 'The password is incorrect.',
    'date' => 'The :attribute is not a valid date.',
    'date_equals' => 'The :attribute must be a date equal to :date.',
    'date_format' => 'The :attribute does not match the format :format.',
    'declined' => 'The :attribute must be declined.',
    'declined_if' => 'The :attribute must be declined when :other is :value.',
    'different' => 'The :attribute and :other must be different.',
    'digits' => 'The :attribute must be :digits digits.',
    'digits_between' => 'The :attribute must be between :min and :max digits.',
    'dimensions' => 'The :attribute has invalid image dimensions.',
    'distinct' => 'The :attribute field has a duplicate value.',
    'email' => 'The :attribute must be a valid email address.',
    'ends_with' => 'The :attribute must end with one of the following: :values.',
    'enum' => 'The selected :attribute is invalid.',
    'exists' => 'The selected :attribute is invalid.',
    'file' => 'The :attribute must be a file.',
    'filled' => 'The :attribute field must have a value.',
    'gt' => [
        'numeric' => 'The :attribute must be greater than :value.',
        'file' => 'The :attribute must be greater than :value kilobytes.',
        'string' => 'The :attribute must be greater than :value characters.',
        'array' => 'The :attribute must have more than :value items.',
    ],
    'gte' => [
        'numeric' => 'The :attribute must be greater than or equal to :value.',
        'file' => 'The :attribute must be greater than or equal to :value kilobytes.',
        'string' => 'The :attribute must be greater than or equal to :value characters.',
        'array' => 'The :attribute must have :value items or more.',
    ],
    'image' => 'The :attribute must be an image.',
    'in' => 'The selected :attribute is invalid.',
    'in_array' => 'The :attribute field does not exist in :other.',
    'integer' => 'The :attribute must be an integer.',
    'ip' => 'The :attribute must be a valid IP address.',
    'ipv4' => 'The :attribute must be a valid IPv4 address.',
    'ipv6' => 'The :attribute must be a valid IPv6 address.',
    'mac_address' => 'The :attribute must be a valid MAC address.',
    'json' => 'The :attribute must be a valid JSON string.',
    'lt' => [
        'numeric' => 'The :attribute must be less than :value.',
        'file' => 'The :attribute must be less than :value kilobytes.',
        'string' => 'The :attribute must be less than :value characters.',
        'array' => 'The :attribute must have less than :value items.',
    ],
    'lte' => [
        'numeric' => 'The :attribute must be less than or equal to :value.',
        'file' => 'The :attribute must be less than or equal to :value kilobytes.',
        'string' => 'The :attribute must be less than or equal to :value characters.',
        'array' => 'The :attribute must not have more than :value items.',
    ],
    'max' => [
        'numeric' => 'The :attribute must not be greater than :max.',
        'file' => 'The :attribute must not be greater than :max kilobytes.',
        'string' => 'The :attribute must not be greater than :max characters.',
        'array' => 'The :attribute must not have more than :max items.',
    ],
    'mimes' => 'The :attribute must be a file of type: :values.',
    'mimetypes' => 'The :attribute must be a file of type: :values.',
    'min' => [
        'numeric' => 'The :attribute must be at least :min.',
        'file' => 'The :attribute must be at least :min kilobytes.',
        'string' => 'The :attribute must be at least :min characters.',
        'array' => 'The :attribute must have at least :min items.',
    ],
    'multiple_of' => 'The :attribute must be a multiple of :value.',
    'not_in' => 'The selected :attribute is invalid.',
    'not_regex' => 'The :attribute format is invalid.',
    'numeric' => 'The :attribute must be a number.',
    'password' => 'The password is incorrect.',
    'present' => 'The :attribute field must be present.',
    'prohibited' => 'The :attribute field is prohibited.',
    'prohibited_if' => 'The :attribute field is prohibited when :other is :value.',
    'prohibited_unless' => 'The :attribute field is prohibited unless :other is in :values.',
    'prohibits' => 'The :attribute field prohibits :other from being present.',
    'regex' => 'The :attribute format is invalid.',
    'required' => 'The :attribute field is required.',
    'required_if' => 'The :attribute field is required when :other is :value.',
    'required_unless' => 'The :attribute field is required unless :other is in :values.',
    'required_with' => 'The :attribute field is required when :values is present.',
    'required_with_all' => 'The :attribute field is required when :values are present.',
    'required_without' => 'The :attribute field is required when :values is not present.',
    'required_without_all' => 'The :attribute field is required when none of :values are present.',
    'same' => 'The :attribute and :other must match.',
    'size' => [
        'numeric' => 'The :attribute must be :size.',
        'file' => 'The :attribute must be :size kilobytes.',
        'string' => 'The :attribute must be :size characters.',
        'array' => 'The :attribute must contain :size items.',
    ],
    'starts_with' => 'The :attribute must start with one of the following: :values.',
    'string' => 'The :attribute must be a string.',
    'timezone' => 'The :attribute must be a valid timezone.',
    'unique' => 'The :attribute has already been taken.',
    'uploaded' => 'The :attribute failed to upload.',
    'url' => 'The :attribute must be a valid URL.',
    'uuid' => 'The :attribute must be a valid UUID.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'custom-message',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'name' => 'name',
        'name_ar' => ' name ar',
        'name_en' => 'name en',
        'email' => 'email',
        'role_id' => 'role',
        'password' => 'password',
        'password_confirmation' => 'password confirmation',
        'mobile_number' => 'mobile number',
        'status' => 'status',
        'driver_license_number' => 'driver license number',
        'driver_license_due_date' => 'driver license due date',
        'national_id_image' => 'national id image',
        'image' => 'image',
        'driver_license_image' => 'driver license image',
        'vehicle_type' => 'vehicle type',
        'category' => 'category',
        'description_ar' => 'description ar',
        'description_en' => 'description en',
        'per_kilometer_fare' => 'per kilometer fare',
        'base_fare' => 'base fare',
        'vehicle_type_icon' => 'vehicle type icon',
        'booking_fare' => 'booking fare',
        'model' => 'model',
        'model_ar' => 'model ar',
        'model_en' => 'model en',
        'brand' => 'brand',
        'brand_ar' => 'brand ar',
        'brand_en' => 'brand en',
        'vehicle' => 'vehicle',
        'car_number' => 'car number',
        'manufacturing_year' => 'manufacturing year',
        'color_ar' => 'color ar',
        'color_en' => 'color en',
        'vehicle_id' => 'vehicle',
        'category_name' => 'category name',
        'category_name_ar' => 'category name ar',
        'category_name_en' => 'category name en',
        'vehicle_type_en' => 'vehicle type en',
        'vehicle_type_ar' => 'vehicle type ar',
        'booking_cancel' => 'booking cancel',
        'region_id' => 'region id',
        'price' => 'price',
        'gender' => 'gender',
        'birthday' => 'birthday ',
        'state_id' => 'state',
        'national_id' => 'national id',
        'driver_type' => 'driver type',
        'percentage_per_order' => 'percentage_per_order',
        'credits' => 'credits',
        'bank_name' => 'bank_name',
        'holder_name' => 'holder name',
        'Bank_Location' => 'bank location',
        'payment_email' => 'payment email',
        'code' => 'code',
        'first_name' => 'first name',
        'last_name' => 'last name',
        'passenger_count' => 'passenger count',
        'balance' => 'balance',
        'type' => 'type ',
        'car_insurance_expire_date' => 'car insurance expire date',
        'car_insurance_image' => 'car insurance image',
        'car_license_image' => 'car license image',
        'max_reach_per_km' => 'max reach per km',
        'service_available_city' => 'service available city',
        'modal_id' => 'modal',
        'brand_id' => 'brand',
        'car_license_expire_date' => 'car license expire date',
        'address_ar' => 'address ar',
        'address_en' => 'address en',
        'category_id' => 'category',
        'mapSearch' => 'Map search',
        'drivery_way' => 'Drivery way',
        'phone' => 'Phone number',
        'from_mishwar' => 'Mishwar',
        'from_restaurant' => 'Restaurant',
        'delivers' => 'Delivers',
        'commission' => 'Commission',
        'identity' => 'Identity',
        'tax' => 'Tax',
        'commercial_id' => 'Commercial id',
        'store_type' => 'Store type',
        'settings' => 'Settings',
        'cases' => 'Cases',
        'mishwarDelivers' => 'Delivers',
        'terms' => 'Terms and Conditions',
        'private_title' => 'privacy policy title',
        'terms_title' => 'Terms and conditions title',
        'terms_description' => 'Terms and conditions description',
        'private_description' => 'privacy policy description',
        'notifications' => 'Notifications',
        'title' => 'Title',
        'message' => 'Message',
        'title_ar' => 'Title ar',
        'message_ar' => 'Message_ar',
        'title_en' => 'Title_en',
        'message_en' => 'Message_en',
        'notification_type' => 'Notification type',
        'user_type' => 'User type',
        'sms' => 'SMS',
        'notification' => 'Notification',
        'low_price' => ' Low price',
        'high_price' => 'High price',
        'price_per_km' => 'Price per km',
        'expected_arrival_time' => 'Expected arrival time',
        'currency_id' => 'currency',
        'currency' => 'currency',
        'discount_type' => 'Discount type',
        'start_date' => 'Start date',
        'expired_date' => 'Expired date',
        'value' => 'Value',
        'percentage' => 'Percentage',
        'discount_' => 'Discount',
        'promoCodes' => 'Promo codes',
        'discount' => 'Discount',
        'store_id' => 'Stores',
        'client_id' => 'Clients',
        'promo_code' => 'Promo code',
        'end_date' => 'End date',
        'offer_type' => 'Offer type',
        'price_before' => 'price before offer',
        'price_after' => 'price after offer',
        'used_number' => 'Used time numbers',
    ],

];
