<?php

namespace App\Models;

use App\Traits\HandleUploadFile;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Translatable\HasTranslations;

class Project extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia, HandleUploadFile  , HasTranslations ;

    protected $table = 'projects';

    protected $fillable = ['name', 'description' , 'is_active'];

    public $translatable = ['name', 'description'];

    // public function categories()
    // {
    //     return $this->belongsTo(Category::class, 'category_id');
    // }

    
    // public function tags() {
    //     return $this->belongsToMany(Tag::class, 'tag_blogs');
    // }

    protected $guarded = ['id'];

    public function scopeOrdered($q)
    {
        return $q->orderBy('id', 'asc');
    }


    // public function storeFile($file, $collection)
    // {
    //     $this->addMedia($file)->toMediaCollection($collection);
    // }

    // public function updateFile($file, $collection)
    // {
    //     $this->clearMediaCollection($collection);
    //     $this->addMedia($file)->toMediaCollection($collection);
    // }
}
