<?php

namespace App\Models;

use App\Traits\HandleUploadFile;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\Translatable\HasTranslations;

class CharitableWork extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia, HandleUploadFile  , HasTranslations ;

    protected $table = 'charitable__works';

    protected $fillable = ['description'];

    public $translatable = ['description'];

    // public function categories()
    // {
    //     return $this->belongsTo(Category::class, 'category_id');
    // }

    
    // public function tags() {
    //     return $this->belongsToMany(Tag::class, 'tag_blogs');
    // }

    protected $guarded = ['id'];

    public function scopeOrdered($q)
    {
        return $q->orderBy('id', 'asc');
    }

    public function storeFile($file, $collectionName)
    {
        $this->clearMediaCollection($collectionName);
        $this->addMedia($file)->toMediaCollection($collectionName);
    }

    public function updateFile($file, $collectionName)
    {
        $this->storeFile($file, $collectionName);
    }
}
