<?php

namespace App\Http\Requests\Front\Dashboard;

use App\Helpers\TranslationHelper;
use Illuminate\Foundation\Http\FormRequest;

class ChangePasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'old_password' => 'required',
            'new_password' => 'required',
        ];
    }

    public function messages()
    {
        return [
            'old_password.required' => TranslationHelper::translate('Please Enter Old Password', 'site'),
            'new_password.required' => TranslationHelper::translate('Please Enter New Password', 'site'),
        ];
    }
}
