<?php

namespace App\Http\Requests\Admin\Project;

use App\Helpers\TranslationHelper;
use Illuminate\Foundation\Http\FormRequest;

class ProjectRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    // public function rules(): array
    // {
    //     return [
    //         'name.ar' => 'required|max:255',
    //         'name.en' => 'required|max:255',
    //         'name.fr' => 'required|max:255',

    //         'description.ar' => 'required',
    //         'description.en' => 'required',
    //         'description.fr' => 'required',
    //         'image' => 'required_without:id|image|mimes:png,jpg,jpeg,webp|nullable',


    //         'project_video_one' => 'nullable|mimes:mp4,mov,avi,wmv|max:512000',
    //         'project_video_tow' => 'nullable|mimes:mp4,mov,avi,wmv|max:512000',


    //     ];
    // }
    public function rules(): array
    {
        $rules = [
            'name.ar' => 'required|max:255',
            'name.en' => 'required|max:255',
            'name.fr' => 'required|max:255',

            'description.ar' => 'required',
            'description.en' => 'required',
            'description.fr' => 'required',

            'image' => 'required_without:id|image|mimes:png,jpg,jpeg,webp|nullable',

            'delete_project_video_ar' => 'sometimes|boolean',
            'delete_project_video_en' => 'sometimes|boolean',
            'delete_project_video_fr' => 'sometimes|boolean',

            'delete_project_video_tow_ar' => 'sometimes|boolean',
            'delete_project_video_tow_en' => 'sometimes|boolean',
            'delete_project_video_tow_fr' => 'sometimes|boolean',
        ];

        foreach (config('language') as $key => $lang) {
            $rules["projectsprojectsproject_video_$key"] = 'nullable|string|url';
            $rules["projectsprojectsproject_video_tow_$key"] = 'nullable|string|url';
        }

        return $rules;
    }



    public function messages(): array
    {
        return [
            'name.ar.required' => TranslationHelper::translate('Please Enter Name'),
            'name.en.required' => TranslationHelper::translate('Please Enter Name'),
            'name.fr.required' => TranslationHelper::translate('Please Enter Name'),

            'image.required_without' => TranslationHelper::translate('Please Upload Image'),
            'image.image' => TranslationHelper::translate('Image is Not Valid'),
            'image.mimes' => TranslationHelper::translate('Image Type is Not Valid'),
            'description.ar.string' => TranslationHelper::translate('Description must be a string'),
            'description.en.string' => TranslationHelper::translate('Description must be a string'),
            'description.fr.string' => TranslationHelper::translate('Description must be a string'),

            'project_video_one.max' => 'حجم الفيديو يجب ألا يتجاوز 500 ميجابايت.',
            'project_video_tow.max' => 'حجم الفيديو يجب ألا يتجاوز 500 ميجابايت.',

            // 'category_id.required' => TranslationHelper::translate('Please Choose Category'),
            // 'meta_image.image' => TranslationHelper::translate('Meta Image is Not Valid'),
            // 'meta_image.mimes' => TranslationHelper::translate('Meta Image Type is Not Valid'),
            // 'meta_description.string' => TranslationHelper::translate('Meta Description must be a string'),
            // 'meta_description.max' => TranslationHelper::translate('Meta Description must not be greater than 160 characters'),
            // 'meta_title.string' => TranslationHelper::translate('Meta Title must be a string'),
            // 'meta_title.max' => TranslationHelper::translate('Meta Title must not be greater than 255 characters'),
            // 'alt_text.string' => TranslationHelper::translate('Alt Text must be a string'),
            // 'alt_text.max' => TranslationHelper::translate('Alt Text must not be greater than 255 characters'),
            // 'meta_tags.array' => TranslationHelper::translate('Meta Tags must be an array'),
        ];
    }
}
