<?php

namespace App\Http\Requests\Admin\Categorycolid;

use App\Helpers\TranslationHelper;
use Illuminate\Foundation\Http\FormRequest;

class CategorycolidRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
        // return auth()->user()->can('edit categorycolid');
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    // public function rules(): array
    // {
    //     return [
    //         'name.ar' => 'required|max:255',
    //         'name.en' => 'required|max:255',
    //         'name.fr' => 'required|max:255',

    //     ];
    // }
    // public function messages(): array
    // {
    //     return [
    //         'name.ar.required' => TranslationHelper::translate('Please Enter Name'),
    //         'name.en.required' => TranslationHelper::translate('Please Enter Name'),
    //         'name.fr.required' => TranslationHelper::translate('Please Enter Name'),
    //     ];
    // }
    public function rules(): array
    {
        $rules = [];

        foreach (config('language') as $locale => $label) {
            $rules["name.$locale"] = 'required|string|max:255';
        }

        return $rules;
    }


    public function messages(): array
{
    $messages = [];
    foreach (config('language') as $locale => $label) {
        $messages["name.$locale.required"] = __('Please enter name in') . ' ' . $label;
    }
    return $messages;
}

}
