<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Hotel;
use App\Models\HotelWish;
use App\Models\Programme;
use App\Models\ProgrammeWish;
use Illuminate\Http\Request;

class WishController extends Controller
{
    public function index() {
        $programme_wishes = ProgrammeWish::with('programme')->where('user_id', auth()->user()->id)->get();
        
        return view('front.pages.user_dashboard.favourite', compact('programme_wishes'));
    }

    // public function changeHotel(Request $request, $id) {
    //     $hotel = Hotel::findOrFail($id);

    //     $check = HotelWish::where('user_id', auth()->user()->id)->where('hotel_id', $hotel->id)->first();

    //     if ($check) {
    //         $check->delete();
    //         return response()->json(['status' => 1, 'msg' => 'Hotel Deleted From Favourite List', 'new_status' => 0]);
    //     } else {
    //         $wish = HotelWish::create([
    //             'hotel_id' => $hotel->id,
    //             'user_id' => auth()->user()->id
    //         ]);
    //         if ($wish) {
    //             return response()->json(['status' => 1, 'msg' => 'Hotel Added to Favourite List Successfully', 'new_status' => 1]);
    //         } else {
    //             return response()->json(['status' => 0, 'msg' => 'Some Error Happened .. Please Try Again Later']);
    //         }
    //     }
    // }
    public function changeProgramme(Request $request, $id) {
        $programme = Programme::findOrFail($id);

        $check = ProgrammeWish::where('user_id', auth()->user()->id)->where('programme_id', $programme->id)->first();

        if ($check) {
            $check->delete();
            return response()->json(['status' => 1,
                'msg' => \App\Helpers\TranslationHelper::translate('Programme Deleted From Favourite List'),'new_status' => 0]);
        } else {
            $wish = ProgrammeWish::create([
                'programme_id' => $programme->id,
                'user_id' => auth()->user()->id
            ]);
            if ($wish) {
                return response()->json(['status' => 1,'msg' => \App\Helpers\TranslationHelper::translate('Programme Added to Favourite List Successfully'), 'new_status' => 1]);

            } else {
                return response()->json(['status' => 0,'msg' => \App\Helpers\TranslationHelper::translate('Some Error Happened .. Please Try Again Later')]);
                    

            }
        }
    }
}
