<?php

namespace App\Http\Controllers\Front;

use App\Helpers\TranslationHelper;
use App\Http\Controllers\Controller;
use App\Http\Requests\Front\ProgrammeBooking\ApplyFormRequest;
use App\Http\Requests\Front\ProgrammeBooking\ProgrammeBookingCheckoutRequest;
use App\Http\Requests\Front\ProgrammeBooking\ProgrammeBookingPayRequest;
use App\Models\Booking;
use App\Models\City;
use App\Models\Country;
use App\Models\Programme;
use App\Models\ProgrammeBooking;
use App\Models\ProgrammeRate;
use App\Models\TourType;
use Illuminate\Http\Request;

class ProgramController extends Controller
{
    public function index(Request $request)
    {
//        return $request;
        $programmes = Programme::query();
        if (
            $request->has('adult_search_count') && $request->adult_search_count != '' && $request->adult_search_count != 0
            && $request->has('children_search_count') && $request->children_search_count != '' && $request->children_search_count != 0
            && $request->has('infant_search_count') && $request->infant_search_count != '' && $request->infant_search_count != 0
        ) {
            $adults = $request->adult_search_count;
            $children = $request->children_search_count;
            $infants = $request->infant_search_count;
            $persons = $adults + $children + $infants;
//            return $persons;
//            return $ids;
            $programmes = $programmes->where('group_size', '>=', $persons);
        }

        if ($request->has('prog_check_in') && $request->prog_check_in != '') {
            $check_in = $request->prog_check_in;
            $programmes = $programmes->whereDate('valid_from', '<=', $check_in)
                ->whereDate('valid_to', '>=', $check_in);
        }
        if ($request->has('tour_type_id') && $request->tour_type_id != '') {
            $tour_type_id = $request->tour_type_id;
            $programmes = $programmes->where('tour_type_id',$tour_type_id);
        }

        if ($request->has('prog_city') && $request->prog_city != '') {
            $programmes = $programmes->where('city_id', $request->prog_city);
        }

        if ($request->has('duration') && $request->duration != '') {
            $programmes = $programmes->where('duration', '>=', $request->duration);
        }
        if ($request->has('prog_stars') && $request->prog_stars != '') {
            $programmes = $programmes->where('avg_rate', '>=', $request->prog_stars);
        }

        $countries = Country::get();
        $cities = City::get();
        $types = TourType::get();

        $programmes = $programmes->active()->orderBy('id', 'desc')->paginate(10);
        return view('front.index', get_defined_vars());
    }



    

    
    // trip_details
    public function show($id)
    {
        $programme = Programme::with([
                'tourType',
                'programmeImages',
                'programmeIncludes',
                'programmeItinerary' => function ($q) {
                    $q->with('programmeItineraryItems');
                }]
        )->find($id);

        $related = collect();
        if ($programme) {
            $related = Programme::where('id', '!=', $programme->id)->limit(12)->get();
        }

        return view('front.pages.programs.trip_details', get_defined_vars());
    }



    public function applyForm(ApplyFormRequest $request, $id)
    {
//        return $request;
        $check_in = $request->check_in;
        $programme = Programme::query()->active()->whereDate('valid_from', '<=', $check_in)->whereDate('valid_to', '>=', $check_in)
            ->find($id);
//        return $programme;
        if ($programme) {
//                return $room;
            $persons = $request->adult_search_count + $request->children_search_count + $request->infant_search_count;

            $data['programme'] = $programme;
            $data['adults'] = $request->adult_search_count;
            $data['children'] = $request->children_search_count;
            $data['infants'] = $request->infant_search_count;
            $data['persons'] = $persons;
            $data['check_in'] = $request->check_in;

            $data['price_before_discount'] = $persons * $programme->price;

            $data['discount'] = $programme->discount . ($programme->discount_type == 'percent' ? '%' : '');
            $data['discount_type'] = $programme->discount_type;
            $data['discount_value'] = $persons * getProgrammeDiscountInNumbers($programme);

            $data['price_after_discount'] = $persons * getProgrammePriceIfDiscountInNumbers($programme);

            $data['tax'] = $programme->tax;
            $data['tax_value'] = (($programme->tax / 100) * $data['price_after_discount']);

            $data['total'] = $data['tax_value'] + $data['price_after_discount'];

            return view('front.pages.programs.form', compact('data'));

        } else {
            return redirect()->back()->with(['error' =>  TranslationHelper::translate('This Programme is Not Available in This Date')]);
        }


    }

    public function bookingApply(ProgrammeBookingCheckoutRequest $request)
    {
//        return $request;
        $check_in = $request->check_in;
        $programme = Programme::query()->active()->whereDate('valid_from', '<=', $check_in)->whereDate('valid_to', '>=', $check_in)
            ->find($request->programme_id);
//            return $programme;
//

        if ($programme) {


            $persons = $request->adult_search_count + $request->children_search_count + $request->infant_search_count;

            $data['user_id'] = auth()->user()->id;
            $data['programme_id'] = $programme->id;
            $data['adults'] = $request->adult_search_count;
            $data['children'] = $request->children_search_count;
            $data['infants'] = $request->infant_search_count;
            $data['persons'] = $persons;
            $data['check_in'] = $request->check_in;


            $data['price_before_discount'] = $persons * $programme->price;
            $data['discount'] = $programme->discount;

            $data['discount_type'] = $programme->discount_type;
            $data['discount_value'] = $persons * getRoomDiscountInNumbers($programme);

            $data['price_after_discount'] = $persons * getProgrammePriceIfDiscountInNumbers($programme);

            $data['tax'] = $programme->tax;
            $data['tax_value'] = (($programme->tax / 100) * $data['price_after_discount']);

            $data['total'] = $data['tax_value'] + $data['price_after_discount'];


            $data['payment_method'] = 'cash';
            $data['payment_status'] = 'unpaid';
            $data['f_name'] = $request->f_name;
            $data['l_name'] = $request->l_name;
            $data['email'] = $request->email;
            $data['phone'] = $request->phone;
            $data['note'] = $request->has('note') ? $request->note : '';

            $booking = ProgrammeBooking::create($data);
            return redirect()->route('user.programme.booking.checkout', $booking->id)->with(['success' => TranslationHelper::translate('Your Request Has Been Sent Successfully .. You Can Pay Now')]);

        } else {
            return redirect()->back()->with(['error' =>  TranslationHelper::translate('This Programme is Not Available')]);
        }

    }

    public function bookingCheckout($id)
    {
        $booking = ProgrammeBooking::find($id);
        if ($booking) {
            return view('front.pages.programs.pay', get_defined_vars());
        } else {
            return redirect()->route('site.home')->with(['error' => TranslationHelper::translate('This Booking Request Dosent Exist')]);
        }
    }

    public function bookingPay(ProgrammeBookingPayRequest $request)
    {
//        return $request;
        $booking = ProgrammeBooking::where('payment_status', 'unpaid')->findOrFail($request->booking_id);
        if ($booking) {
            if ($request->payment_method == 'cash') {
                $booking->update(['payment_method' => 'cash', 'payment_status' => 'paid']);

            }
            if ($request->has('rate') && $request->rate != '') {
                $rate = ProgrammeRate::create([
                    'programme_id' => $booking->programme_id,
                    'programme_booking_id' => $booking->id,
                    'rate' => $request->rate,
                    'comment' => $request->comment,
                ]);
                $programme = Programme::find($booking->programme_id);
//                updateProgrammeRateAvg($programme);
            }
            return redirect()->route('site.home')->with(['success' => TranslationHelper::translate('Your Booking Request Has Been Paid Successfully')]);

        } else {
            return redirect()->route('site.home')->with(['error' => TranslationHelper::translate('This Booking Request Dosent Exist')]);
        }
    }

    public function booking()
    {
        return view('front.pages.programs.book');
    }
}
